﻿import bpy
from ..core import state

class MainPanel(bpy.types.Panel):
    bl_label = "DollarsMoCap"
    bl_idname = "OBJECT_PT_DOLLARSMOCAP_MENU"
    bl_space_type = "VIEW_3D"
    bl_region_type = "UI"
    bl_category = 'DollarsMoCap'
    
    @classmethod
    def poll(cls, context):
        return True
        
    def draw_header(self, context):
        try:
            layout = self.layout
        except Exception as exc:
            print(str(exc) + " | Error in Dollars panel header")
            
    def draw(self, context):
        layout = self.layout
        scene = context.scene

        config = layout.column()
        config.enabled = not state.server.is_alive()
        config.prop(context.scene, "dollars_performer_port")

        # 👉 添加 mesh 数组 UI
        mesh_collection = scene.dollars_mesh_collection
        box = layout.box()
        box.label(text="Meshes:")

        row = box.row()
        row.template_list("MESH_UL_items", "", mesh_collection, "items", mesh_collection, "active_index", rows=2)

        col = row.column(align=True)
        col.operator("dollars_mesh_list.add_item", icon='ADD', text="")
        col.operator("dollars_mesh_list.remove_item", icon='REMOVE', text="")
        col.separator()
        col.operator("dollars_mesh_list.clear_list", icon='X', text="")

        if mesh_collection.items and mesh_collection.active_index < len(mesh_collection.items):
            item = mesh_collection.items[mesh_collection.active_index]
            sub_box = box.box()
            sub_box.prop(item, "mesh_object")
        # Armature selection with box and label
        box = layout.box()
        box.label(text="Armature:")
        box.prop_search(
            context.scene, "dollars_target_armature", bpy.data, "objects", text="")

        # Hip height input box
        box = layout.box()
        row = box.row()
        row.label(text="Hip Height:")
        row.prop(scene, "dollars_hip_height", text="")


        # Action buttons
        row = layout.row(align=True)
        row.scale_y = 1.3
        if not state.server.is_alive():
            row.operator("dollars.connect", icon="PLAY")
        else:
            row.operator("dollars.disconnect", icon="PAUSE")

        row = layout.row(align=True)
        row.scale_y = 1.3
        if not state.is_recording:
            row.operator("dollars.startrecording", icon="RADIOBUT_ON")
        else:
            row.operator("dollars.stoprecording", icon="RADIOBUT_OFF")
